#!/bin/sh
# 
# Configure Thai keyboard for Red Hat 8
#
# $Id: rh8_xkb.sh,v 1.1 2003-05-09 14:16:56 poonlap Exp $


echo -ne "\nChanging X Keyboard Layout to be \033[01;32mth\033[00m...\n"
echo -ne "\033[01;32mALT+SHIFT_R\033[00m will switch to Thai\n"
echo -ne "\033[01;32mALT+SHIFT_L\033[00m will switch to English\n"
cp /etc/X11/XF86Config /etc/X11/XF86Config.backup
grep '^[^#].*XkbLayout' /etc/X11/XF86Config 1> /dev/null 2> /dev/null
if [ $? == "1" ] ; then
	echo -ne "\033[01;31mError:\033[00m XkbLayout identifier not found in /etc/X11/XF86Config\n"
	echo "       Please add the following lines yourself under your keyboard section in the X config file later:"
	echo "	 	Option \"XkbLayout\" \"th\""
else
	cat /etc/X11/XF86Config.backup | sed 's/^[^#].*"XkbLayout".*$/        Option  "XkbLayout" "th"/' > /etc/X11/XF86Config
	echo -ne "Just in case.. I have backed up your original X config file to \033[01;34m/etc/X11/XF86Config.backup\033[00m\n"
fi
echo -e "\nPress <ENTER> to continue\n"
read
