<?php

class Mo_File
{
 var $fh;
 var $catalog = array('hello'=>'ʴ');	# result cache
 var $format;						# for unpack
 var $version = 0;
 var $msgcount;
 var $master_start;			# for fseek
 var $trans_start;				# for fseek
 

 function Mo_File($filename=""){
	if (!empty($filename)){
		$this->set_file($filename);
	}
	return true;
 }

 function set_file($filename){
	$this->fh = fopen($filename, 'r');
	$this->parse();
 }

 function parse(){
	// some TODO here:
	// should add some code to check header here for little/big endian
	// and change the $format to 'N*' or 'V*' accordingly;
	$this->format = 'V*';	# for my test machine
	list($this->version, $this->msgcount, $this->master_start, $this->trans_start)
		= $this->fget_words(4, 16);
	// should check metadata in get_trans(0) if exists, such as char-set
 }

 function fget_words($offset, $length){
	fseek($this->fh, $offset);
	$bindata = fread($this->fh, $length);
	return array_values(unpack($this->format, $bindata));
 }

 function gettext($msg){
	if (isset($this->catalog[$msg])){
		return $this->catalog[$msg];
	}

	$idx = $this->binary_search($msg);
	if ($this->get_master($idx)==$msg){
		$tmsg = $this->get_trans($idx);
	} else {
		$tmsg = $msg;
	}

	$this->catalog[$msg] = $tmsg;
	return $tmsg;
 }

 function binary_search($target){
	$low = 0;
	$high = $this->msgcount -1;
	while ($low < $high) {
		$cur = intval(($low + $high) / 2);
		if ($this->get_master($cur) < $target)
			$low = $cur+1;
		else
			$high = $cur;
	}
	return $low;	# not necessarily equal to $target
 }

 function get_master($idx){
	// quicker than to call fget_words
	fseek($this->fh, $this->master_start + 8*$idx);
	list( , $length, $offset) = unpack( $this->format, fread($this->fh, 8));
	fseek($this->fh, $offset);
	return fread($this->fh, $length);
 }

 function get_trans($idx){
	fseek($this->fh, $this->trans_start + 8*$idx);
	list( , $length, $offset) = unpack( $this->format, fread($this->fh, 8));
	fseek($this->fh, $offset);
	return fread($this->fh, $length);
 }

 function clear_cache(){
	$this->catalog = array();
 }

 function close_file(){
	fclose($this->fh);
 }
} # class Mo_File

#$_translations = new Mo_File();

// public function for initialization;
function set_mofile($filename){
	global $_translations;
	if (isset($_translations)){
		$_translations->close_file();
	}
	$_translations = new Mo_File;
	return $_translations->set_file($filename);
}

// public function 
function _($str){
	global $_translations;
	return $_translations->gettext($str);
	# version  ¡ҹ object 
	/*
	global $fh;
	global $master_start;
	global $trans_start;

	$low = 0;
	$high = $GLOBALS['msgcount'] -1;
	while ($low < $high) {
		$cur = intval(($low + $high) / 2);

		fseek($fh, $master_start + 8*$cur);
		list( , $length, $offset) = unpack( 'V*', fread($fh, 8));
		fseek($fh, $offset);

		if ( fread($fh, $length) < $str)
			$low = $cur+1;
		else
			$high = $cur;
	}
	#return $low;	# not necessarily equal to $target
	fseek($fh, $master_start + 8*$low);
	list( , $length, $offset) = unpack( 'V*', fread($fh, 8));
	fseek($fh, $offset);

	if ( fread($fh, $length)==$str ){
		fseek($fh, $trans_start + 8*$low);
		list( , $length, $offset) = unpack( 'V*', fread($fh, 8));
		fseek($fh, $offset);
		return fread($fh, $length);
	} else {
		return $str;
	}
	*/
}
/*
function pre_call(){
	global $_translations;
	$GLOBALS['msgcount'] = $_translations->msgcount;
	$GLOBALS['fh'] = $_translations->fh;
	$GLOBALS['master_start'] = $_translations->master_start;
	$GLOBALS['trans_start'] = $_translations->trans_start;
}
*/

/*
set_mofile("/httpd/tlwg/language/th/LC_MESSAGES/phpnuke.mo");
$str = _("Articles");
echo $str;
#echo $_translations->get_trans(2);
echo "\n";
#print_r($_translations);
#echo $_translations->;
*/
?>