#ifndef __XKLAVIER_H__
#define __XKLAVIER_H__

typedef struct
{
  int     group;
} XklState;

#define PROP_LENGTH 1

extern int XklInit( Display* dpy );
extern int XklTerm( void );

extern int XklStartListen( void );

extern Window XklGetCurrentWindow( void );

extern Bool XklGetState( Window win, XklState *state );
extern void XklDelState( Window win );
extern void XklSaveState( Window win, XklState *state );

extern unsigned XklGetNumGroups( void );

extern const char ** XklGetGroupNames( void );

extern int XklGetNextGroup( void );
extern int XklGetPrevGroup( void );
extern int XklGetRestoreGroup( void );
extern void XklLockGroup( int group, Bool restore );

typedef void (* WinCallback ) ( Window win, Window parent, void * userData );
extern int XklRegisterWindowCallback( WinCallback fun, void* userData );

typedef void (* StateCallback ) ( int group, Bool restoreState, void * userData );
extern int XklRegisterStateCallback( StateCallback fun, void* userData );

extern int XklFilterEvents( XEvent * evt );

extern const char* XklGetLastError( void );

extern Bool XklGrabKey( int key, unsigned modifiers );
extern Bool XklUngrabKey( int key, unsigned modifiers );

extern char* XklGetWindowTitle( Window w );

extern Bool XklIsSameApp( Window win1, Window win2 );

extern void XklSetLayoutPerApp( Bool isGlobal );
extern Bool XklIsLayoutPerApp( void );

extern void _XklDebug( const char file[], const char function[], const char format[], ... );

#define XklDebug( format, args... ) \
  _XklDebug( __FILE__, __func__, format, ## args )

#endif
