#include "gswitchit.h"

#include "../src/gswitchit.h"

/*** App-specific servant structures ***/
typedef struct
{
   POA_GNOME_GSwitchIt servant;
   PortableServer_POA poa;

   GSwitchItApplet * theApplet;
}
impl_POA_GNOME_GSwitchIt;

static void
impl_GNOME_GSwitchIt_rereadConfig(impl_POA_GNOME_GSwitchIt * servant,
                                  CORBA_Environment * ev);

/*** Implementation stub prototypes ***/
static void impl_GNOME_GSwitchIt__destroy(impl_POA_GNOME_GSwitchIt * servant,
					  CORBA_Environment * ev);

/*** epv structures ***/
static PortableServer_ServantBase__epv impl_GNOME_GSwitchIt_base_epv = {
   NULL,			/* _private data */
   (gpointer) & impl_GNOME_GSwitchIt__destroy, //NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GNOME_GSwitchIt__epv impl_GNOME_GSwitchIt_epv = {
   NULL,			/* _private */
   (gpointer) & impl_GNOME_GSwitchIt_rereadConfig,

};

/*** vepv structures ***/
static POA_GNOME_GSwitchIt__vepv impl_GNOME_GSwitchIt_vepv = {
   &impl_GNOME_GSwitchIt_base_epv,
   &impl_GNOME_GSwitchIt_epv,
};

/*** Stub implementations ***/
static GNOME_GSwitchIt
impl_GNOME_GSwitchIt__create( GSwitchItApplet * applet, PortableServer_POA poa, CORBA_Environment * ev)
{
   GNOME_GSwitchIt retval;
   impl_POA_GNOME_GSwitchIt *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GNOME_GSwitchIt, 1);
   newservant->servant.vepv = &impl_GNOME_GSwitchIt_vepv;
   newservant->poa = poa;
   newservant->theApplet = applet;
   POA_GNOME_GSwitchIt__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GNOME_GSwitchIt_rereadConfig( impl_POA_GNOME_GSwitchIt * servant,
                                        CORBA_Environment * ev)
{
  gswitchit_config_load( &servant->theApplet->config );
  gswitchit_applet_revalidate( servant->theApplet );
}

static void
impl_GNOME_GSwitchIt__destroy(impl_POA_GNOME_GSwitchIt * servant,
			      CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GNOME_GSwitchIt__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CORBA_Object root_poa, theObj;

#if 0
static CosNaming_Name ctxname = { 2, 2, name_component, CORBA_FALSE };

static void listNames()
{
  CosNaming_BindingList *binds;
  CosNaming_BindingIterator iter;
  CosNaming_Name name;
  CosNaming_NameComponent *nc;
  CosNaming_NamingContext parctx;
  CORBA_long i,j;

  parctx = CosNaming_NamingContext_resolve( (CosNaming_NamingContext)gnome_name_service_get(),
                                   &ctxname,
                                   &corba_env );
  gswitchit_check_corba_error();
  CosNaming_NamingContext_list( parctx,
                                10,
                                &binds,
                                &iter,
                                &corba_env );
  gswitchit_check_corba_error();

  fprintf( stderr, "total: %u names\n", binds->_length );

  for (i = 0; i < binds->_length; i++)
  {
    name = binds->_buffer[i].binding_name;
    for ( j = name._length; --j>=0 ; )
    {
      nc = &name._buffer[j];
      fprintf ( stderr, "%s%s%s%s",
                nc->id,
                strlen (nc->kind) > 0 ? "." : "",
                nc->kind,
                binds->_buffer[i].binding_type == CosNaming_ncontext ?
                "/" : "");
    }

    fprintf( stderr, "\n" );
  }

  CORBA_free( binds );
}
#endif

gboolean gswitchit_corba_init( GSwitchItApplet* applet, int* pargc, char ** argv )
{
  PortableServer_POAManager root_poa_manager;

  gswitchit_gnorba_env_init( TRUE,
                             pargc,
                             argv,
                             GNORBA_INIT_SERVER_FUNC );
  gswitchit_corba_check_error();

  root_poa = CORBA_ORB_resolve_initial_references( gnome_CORBA_ORB(),
                                                   "RootPOA",
                                                   &corba_env );
  gswitchit_corba_check_error();

  root_poa_manager = PortableServer_POA__get_the_POAManager( (PortableServer_POA)root_poa,
                                                             &corba_env );
  gswitchit_corba_check_error();

  PortableServer_POAManager_activate( root_poa_manager, &corba_env );
  gswitchit_corba_check_error();

  theObj = impl_GNOME_GSwitchIt__create( applet, (PortableServer_POA)root_poa, &corba_env );
  gswitchit_corba_check_error();

  CosNaming_NamingContext_bind( gnome_name_service_get(),
                                &name,
                                theObj,
                                &corba_env );
  gswitchit_corba_check_error();

  return TRUE;
}

void gswitchit_corba_term( GSwitchItApplet* applet )
{
}
