/* xxkb  - XKB keyboard indicator/switcher */
/* (c)  1999 2000 2001 Ivan Pascal <pascal@tsu.ru>   */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/XKBlib.h>
#include <X11/Xlibint.h>

#define XK_MISCELLANY
#include <X11/keysymdef.h>

#include "xxkb.h"
#include "xklavier.h"

#define	NAME	"XXkb"

#include <X11/IntrinsicP.h>
static XtAppContext app_cont;

XXkbConfig conf;

Display *dpy;
int scr;
GC gc;

//Window root, MainWin, icon, win, focused, base_mask;
Window root, MainWin;
//int revert, grp;
char *name = NAME;
//Atom take_focus_atom, xxkb_state, xxkb_icon_window, xxkb_managed_window;
Atom xxkb_icon_window, xxkb_managed_window;

//kbdState def_state, cur_state;
Window cur_button;

//XFocusChangeEvent focused_event;
XErrorHandler DefErrHandler;

static void AddWindowCallback(Window win, Window parent, void *userData)
{
  Window button = XxkbMakeButton(win, parent);
  if (button)
    XxkbSaveWindow(win, xxkb_icon_window, button);
}

static void XxkbStateCallback(int group, Bool restore, void *user_data)
{
  printf ( "Wow. Now I am going to setup the window using group %d\n!", group );
  XxkbUpdateWindow(MainWin, gc, group);
  if (cur_button)
    XxkbUpdateButton(cur_button, gc, group);
}

int main(int argc, char **argv)
{
  // int xkbEventType, xkbError, reason_rtrn;
  // Bool fout_flag = False;
  Geometry geom;
  XWMHints *wm_hints;
  XClassHint class_hints;
  XSizeHints *size_hints;
  XkbEvent ev;

/* Lets begin */
  dpy = XOpenDisplay("");

  XSynchronize( dpy, True );

  if (!dpy) {
    puts("Can' connect to X-server");
    exit(-1);
  }
  XxkbReset();
  if ( XklInit(dpy) )
  {
    XklDebug( "xxkb", "lib", "XklInit returned %s\n", XklGetLastError() );
    return 1;
  }

  scr = DefaultScreen(dpy);
  root = RootWindow(dpy, scr);
  DefErrHandler = XSetErrorHandler((XErrorHandler) XxkbErrHandler);

  app_cont = XtCreateApplicationContext();
  XtDisplayInitialize(app_cont, dpy, name, name, NULL, 0, &argc, argv);
  XxkbGetConfig(dpy, &conf);

  xxkb_icon_window = XInternAtom(dpy, "XXKB_ICON_WINDOW", False);
  xxkb_managed_window = XInternAtom(dpy, "XXKB_MANAGED_WINDOW", False);

/* My MAIN window */
  geom = conf.main_geom;
  if (geom.mask & (XNegative | YNegative)) {
    int x, y;
    unsigned int width, height, bord, dep;
    Window rwin;
    XGetGeometry(dpy, root, &rwin, &x, &y, &width, &height, &bord, &dep);
    if (geom.mask & XNegative)
      geom.x = width + geom.x - geom.width;
    if (geom.mask & YNegative)
      geom.y = height + geom.y - geom.height;
  }

  MainWin = XCreateSimpleWindow(dpy, root,
        geom.x, geom.y,
        geom.width, geom.height, 0,
        BlackPixel(dpy, scr),
        WhitePixel(dpy, scr));

  wm_hints = XAllocWMHints();
  wm_hints->window_group = MainWin;
  wm_hints->input = False;
  wm_hints->flags = InputHint | WindowGroupHint;
  XSetWMHints(dpy, MainWin, wm_hints);
  XStoreName(dpy, MainWin, name);

  class_hints.res_name = name;
  class_hints.res_class = name;
  XSetClassHint(dpy, MainWin, &class_hints);
  XSetCommand(dpy, MainWin, argv, argc);

  if (geom.mask & (XValue | YValue))
  {
    size_hints = XAllocSizeHints();
    size_hints->x = geom.x;
    size_hints->y = geom.y;
    size_hints->flags = USPosition;
    XSetNormalHints(dpy, MainWin, size_hints);
  }

  XMapWindow(dpy, MainWin);

/* What events we want */
  XSelectInput(dpy, MainWin, ExposureMask | ButtonPressMask);

  XxkbGetGC(MainWin, &gc);

/* set current defaults */
  XklRegisterWindowCallback(AddWindowCallback, NULL);
  XklRegisterStateCallback(XxkbStateCallback, NULL);

  XklStartListen();

  cur_button = XxkbGetIcon(XklGetCurrentWindow());
  XklDebug( "set cur_button=%lX from %lX\n", cur_button, XklGetCurrentWindow() );

//!!
  XklGrabKey( XK_Shift_R, ShiftMask );


/* Main Loop */
  while (1)
  {
    Window win;
    XklState state;

    XNextEvent(dpy, &ev.core);

    XklDebug( "Processing evt: %ld\n", ev.any.serial );

    XklFilterEvents(&ev.core);

    XklGetState( XklGetCurrentWindow(), &state );

    switch (ev.type)
    {  /* core events */
      case Expose:  /* Update our window or button */
        if (ev.core.xexpose.count != 0)
          break;
        win = ev.core.xexpose.window;
        if (win == MainWin)
          XxkbUpdateWindow(win, gc, state.group);
        else
        {
          Window client = XxkbGetManagedWindow(win);
          if (client)
          {
            XklGetState(client, &state);
            XxkbUpdateButton(win, gc, state.group);
          }
        }
        break;
      case ButtonPress:
        win = ev.core.xbutton.window;
        switch (ev.core.xbutton.button)
        {
        case Button1:
          if ((win == cur_button) || (win == MainWin))
          {
            XklLockGroup( state.group + 1, False );
          }
          break;
        case Button3:
          if ((win == cur_button) || (win == MainWin))
          {
            XklLockGroup( state.group + 1, False );
          }
          break;
        case Button2:
          if (win != MainWin)
          {
            Window client = XxkbGetManagedWindow(win);
            if (client)
              XxkbSaveWindow(client, xxkb_icon_window, (Window) 0);
            XDestroyWindow(dpy, win);

            if (win == cur_button)
              cur_button = 0;
            break;
          }

          XFreeGC(dpy, gc);

          XDestroyWindow(dpy, MainWin);
          XtCloseDisplay(dpy);

          exit(0);
        }
        break;
        /*!!case ReparentNotify:
           win = ev.core.xreparent.window;
           if( win == MainWin ||
           ev.core.xreparent.parent == root ||
           BASE(ev.core.xreparent.parent) == BASE(win) ||
           ev.core.xreparent.override_redirect == TRUE ) break;

           AddWindow(win, ev.core.xreparent.parent, False, def_state);
           break; */
      case ConfigureNotify:
        win = ev.core.xconfigure.above;
        if (win && !(win == MainWin) &&
            XklIsSameApp(win, MainWin))
          XRaiseWindow(dpy, win);
        break;
      case FocusIn:
        win = ev.core.xfocus.window;
        cur_button = XxkbGetIcon(win);
        XklDebug( "set cur_button=%lX\n", cur_button );
        break;
    }
  }
  return (0);
}

void XxkbReset()
{
  cur_button = 0;
}


void XxkbGetGC(Window win, GC * gc)
{
  unsigned long valuemask = 0;	/* No data in ``values'' */
  XGCValues values;
  *gc = XCreateGC(dpy, win, valuemask, &values);
/*	XSetForeground(dpy, *gc, BlackPixel(dpy, scr)); */
}

void XxkbUpdateWindow(Window win, GC gc, int group)
{
  printf ( "painting the window %lX using group %d\n", win, group );
  if (conf.pictures[group])
    XPutImage(dpy, win, gc, conf.pictures[group],
        0, 0, 0, 0, conf.main_geom.width, conf.main_geom.height);
}

void XxkbUpdateButton(Window win, GC gc, int group)
{
  if (win && conf.pictures[group + 4])
    XPutImage(dpy, win, gc, conf.pictures[group + 4],
        0, 0, 0, 0, conf.but_geom.width, conf.but_geom.height);
}

Window XxkbMakeButton(Window win, Window parent)
{
  Window button, rwin;
  int x, y;
  unsigned int width, height, bord, dep;
  XSetWindowAttributes attr;
  Geometry geom = conf.but_geom;

  if ((parent = XxkbGetGrandParent(parent)) == (Window) NULL)
    return (Window) NULL;

  if (geom.mask & (XNegative | YNegative))
    if (XGetGeometry(dpy, parent, &rwin,
         &x, &y, &width, &height, &bord, &dep)) {
      x = (geom.mask & XNegative) ? width + geom.x - geom.width : geom.x;
      y = (geom.mask & YNegative) ? height + geom.y - geom.height : geom.y;
    }
  if ((geom.width > width) || (geom.height > height))
    return (Window) NULL;

  button = XCreateSimpleWindow(dpy, parent,
             x, y, geom.width, geom.height, 0,
             BlackPixel(dpy, scr), WhitePixel(dpy, scr));

  attr.override_redirect = True;
  attr.win_gravity = geom.gravity;

  XChangeWindowAttributes(dpy, button, CWWinGravity | CWOverrideRedirect,
        &attr);
  XSelectInput(dpy, parent, SubstructureNotifyMask);
  XSelectInput(dpy, button, ExposureMask | ButtonPressMask);
  XxkbSaveWindow(button, xxkb_managed_window, win);
  XMapRaised(dpy, button);
  return button;
}

Window XxkbGetGrandParent(Window w)
{
  Window rwin, parent, *child;
  int num;

  while (1) {
    if (!XQueryTree(dpy, w, &rwin, &parent, &child, &num))
      return (Window) NULL;
    if (child)
      XFree(child);
    if (parent == rwin)
      return w;
    w = parent;
  }
}

void XxkbErrHandler(Display * dpy, XErrorEvent * err)
{
  if ((err->error_code == BadWindow) || (err->error_code == BadDrawable))
    return;
  (*DefErrHandler) (dpy, err);
}

Window XxkbGetIcon(Window win)
{
  Atom type_ret;
  int format_ret;
  unsigned long nitems, rest;
  unsigned char *prop;
  Window ret = (Window) NULL;
  if ((XGetWindowProperty(dpy, win, xxkb_icon_window, 0L, 1L, False,
        XA_WINDOW, &type_ret, &format_ret, &nitems,
        &rest, &prop) == Success)
      && (type_ret == XA_WINDOW) && (format_ret == 32)) {
    ret = *((Window *) prop);
    XFree(prop);
  }
  return ret;
}

Window XxkbGetManagedWindow(Window icon)
{
  Atom type_ret;
  int format_ret;
  unsigned long nitems, rest;
  unsigned char *prop;
  Window ret = (Window) NULL;
  if ((XGetWindowProperty(dpy, icon, xxkb_managed_window, 0L, 1L, False,
        XA_WINDOW, &type_ret, &format_ret, &nitems,
        &rest, &prop) == Success)
      && (type_ret == XA_WINDOW) && (format_ret == 32)) {
    ret = *((Window *) prop);
    XFree(prop);
  }
  return ret;
}

void XxkbSaveWindow(Window win, Atom prop_name, Window prop)
{
  XChangeProperty(dpy, win, prop_name, XA_WINDOW, 32, PropModeReplace,
      (unsigned char *) &prop, 1);
}
