#ifndef __GSWITCHIT_H__
#define __GSWITCHIT_H__

#include <config.h>

#include <X11/Xlib.h>
#include <X11/XKBlib.h>

#include <applet-widget.h>

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gconf/gconf-client.h>

#define GROUP_MASK 0x1FFF

typedef struct _GSwitchItConfig
{
  int secondaries;

  GdkPixbuf* images[XkbNumKbdGroups];

  GdkPixmap* activeImage;
  GdkBitmap* activeMask;

  gchar* imageFiles[XkbNumKbdGroups];

  gboolean doBeep;
  gboolean layoutPerApp;

  int switchcutId;
  int switchcutKeysym;
  int switchcutState;
  int switchcutAutoKeycode;

  GConfClient* confClient;

  int switchApproved;
  gboolean allowSecondary;
  gboolean forceNoBeep;

} GSwitchItConfig;

extern void GSwitchItConfigInit( GSwitchItConfig* config, gboolean doLoad );
extern void GSwitchItConfigLoad( GSwitchItConfig* config );
extern void GSwitchItConfigSave( GSwitchItConfig* config );
extern void GSwitchItConfigTerm( GSwitchItConfig* config, gboolean doSave );

extern void GSwitchItConfigLoadImages( GSwitchItConfig* config );
extern void GSwitchItConfigFreeImages( GSwitchItConfig* config );

extern gboolean GSwitchItConfigGrabSwitchcut( GSwitchItConfig* config );
extern gboolean GSwitchItConfigUngrabSwitchcut( GSwitchItConfig* config );

extern void GSwitchItConfigLockNextGroup( GSwitchItConfig* config );
extern void GSwitchItConfigLockPrevGroup( GSwitchItConfig* config );
extern void GSwitchItConfigRestoreGroup( GSwitchItConfig* config );

extern void GSwitchItConfigApproveSwitch( GSwitchItConfig* config, int group );
extern gboolean GSwitchItConfigIsSwitchApproved( GSwitchItConfig* config, int group );
extern gboolean GSwitchItConfigProcessSwitch( GSwitchItConfig * config, int group );

typedef struct _GSwitchItApplet
{
  GSwitchItConfig config;

  GtkWidget* applet;
  GtkWidget* drawingArea;
  GtkWidget* aboutBox;
  GtkWidget* border;
  GtkWidget* propBox;

} GSwitchItApplet;

extern void GSwitchItAppletRevalidate( GSwitchItApplet* sia );
extern void GSwitchItAppletRevalidateGroup( GSwitchItApplet* sia, int group );

extern GdkFilterReturn GSwitchItAppletFilterXEvt( GdkXEvent* xevent,
                                                  GdkEvent* event,
                                                  GSwitchItApplet* sia );

#define CONFIG_KEY_IMAGES_FMT "/apps/" PACKAGE "/Images/%d"
#define CONFIG_KEY_SECONDARIES "/apps/" PACKAGE "/General/secondary"
#define CONFIG_KEY_BEEP "/apps/" PACKAGE "/General/beep"
#define CONFIG_KEY_GROUP_PER_WINDOW "/apps/" PACKAGE "/General/groupPerWindow"
#define CONFIG_KEY_SWITCHCUT_ID "/apps/" PACKAGE "/General/switchcutId"
#define CONFIG_KEY_SWITCHCUT_KEYSYM "/apps/" PACKAGE "/General/switchcutKeysym"
#define CONFIG_KEY_SWITCHCUT_STATE "/apps/" PACKAGE "/General/switchcutState"

#endif

