#include <config.h>
#include "capplet-widget.h"

#include <gdk/gdkx.h>

#include <sys/stat.h>

#include "gnome.h"
#include "../src/gswitchit.h"
#include "../src/switchcuts.h"
#include "../xklavier/xklavier.h"

static GtkWidget *capplet;

static GSwitchItConfig *savedState;
static GtkWidget *grabDialog;
static GtkWidget *udMenu;
static GtkWidget *switchcutsOMenu;

char * CappletKeyeventToString(guint keysym, guint state)
{
  GString *gstr;
  char *sep = "";
  char *key;

  key = XKeysymToString( keysym );
  if(key == NULL)
    return NULL;

  gstr = g_string_new(NULL);
  if(state & ControlMask)
  {
    g_string_append(gstr, "Ctrl");
    sep = "-";
  }
  if(state & LockMask)
  {
    g_string_append(gstr, sep);
    g_string_append(gstr, "Lock");
    sep = "-";
  }
  if(state & ShiftMask)
  {
    g_string_append(gstr, sep);
    g_string_append(gstr, "Shift");
    sep = "-";
  }
  if(state & Mod1Mask)
  {
    g_string_append(gstr, sep);
    g_string_append(gstr, "Alt");
    sep = "-";
  }
  if(state & Mod2Mask)
  {
    g_string_append(gstr, sep);
    g_string_append(gstr, "Mod2");
    sep = "-";
  }
  if(state & Mod3Mask)
  {
    g_string_append(gstr, sep);
    g_string_append(gstr, "Mod3");
    sep = "-";
  }
  if(state & Mod4Mask)
  {
    g_string_append(gstr, sep);
    g_string_append(gstr, "Mod4");
    sep = "-";
  }
  if(state & Mod5Mask)
  {
    g_string_append(gstr, sep);
    g_string_append(gstr, "Mod5");
    sep = "-";
  }
  g_string_append(gstr, sep);
  g_string_append(gstr, key);
  {
    char *ret = gstr->str;
    g_string_free(gstr, FALSE);
    return ret;
  }
}

static void CappletUpdateGrabMenu(GSwitchItConfig *sc)
{
  if (GTK_IS_LABEL (udMenu))
  {
    gchar *label;
    gchar **text;
    gchar *keystring;

    gtk_label_get (GTK_LABEL (udMenu), &label);
    keystring = g_strconcat(" ", CappletKeyeventToString(sc->switchcutKeysym, sc->switchcutState), '\0');
    text = g_strsplit(label, ":", 1);
    keystring = g_strjoin(":", text[0], keystring , '\0');
    gtk_label_set_text(GTK_LABEL(udMenu), keystring);
    gtk_option_menu_set_history( GTK_OPTION_MENU( switchcutsOMenu ), 0 );
    gtk_option_menu_set_history( GTK_OPTION_MENU( switchcutsOMenu ), sc->switchcutId);
    g_strfreev(text);
    g_free(keystring);
  }
}

static GdkFilterReturn CappletGrabKeyFilter(GdkXEvent * gdkxevent, GdkEvent * event, gpointer si)
{
  XEvent *xevent = (XEvent *)gdkxevent;
  GSwitchItConfig *sc = (GSwitchItConfig *)si;

  if(xevent->type != KeyPress && xevent->type != KeyRelease)
    return GDK_FILTER_CONTINUE;

  sc->switchcutId = total_switchcuts - 1;
  sc->switchcutKeysym = XKeycodeToKeysym( GDK_DISPLAY(), xevent->xkey.keycode, 0 );
  sc->switchcutState = xevent->xkey.state & GROUP_MASK;
  XklDebug( "id[%d]\tkeysym[%d]\tstate[%d][%d]\n",
    sc->switchcutId, sc->switchcutKeysym, xevent->xkey.state, sc->switchcutState );
  CappletUpdateGrabMenu(sc);

  gdk_keyboard_ungrab(GDK_CURRENT_TIME);
  gtk_widget_destroy(grabDialog);
  gdk_window_remove_filter(GDK_ROOT_PARENT(), CappletGrabKeyFilter, (gpointer)si);
  return GDK_FILTER_REMOVE;
}
static void CappletGrabDialog(GtkWidget *w, GSwitchItConfig* si )
{
  GtkWidget *grabFrame;
  GtkWidget *grabHbox;
  GtkWidget *grabLabel;

  capplet_widget_state_changed( CAPPLET_WIDGET (capplet), TRUE );
  gdk_window_add_filter(GDK_ROOT_PARENT(), CappletGrabKeyFilter, (gpointer)si);

  grabDialog = gtk_window_new(GTK_WINDOW_POPUP);
  gdk_keyboard_grab(GDK_ROOT_PARENT(), TRUE, GDK_CURRENT_TIME);
  gtk_window_set_modal(GTK_WINDOW(grabDialog), TRUE);
  gtk_window_set_position(GTK_WINDOW(grabDialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy(GTK_WINDOW(grabDialog), FALSE, FALSE, TRUE);

  grabFrame = gtk_frame_new(NULL);
  gtk_container_add(GTK_CONTAINER(grabDialog), grabFrame);

  grabHbox = gtk_hbox_new(0, 0);
  gtk_container_set_border_width(GTK_CONTAINER(grabHbox), 40);
  gtk_container_add(GTK_CONTAINER(grabFrame), grabHbox);

  grabLabel = gtk_label_new(_("Press your switchcut key(s).."));
  gtk_container_add(GTK_CONTAINER(grabHbox), grabLabel);
  gtk_widget_show_all(grabDialog);

}

static void CappletConfigUpdate(GtkWidget *w, GSwitchItConfig* si )
{
  GnomeIconEntry* ie[XkbNumKbdGroups];
  gint i;

  for ( i=XklGetNumGroups();
        --i>=0; )
  {
    char sz[30];
    struct stat buf;
    char *fn;

    g_snprintf( sz, sizeof(sz), "iconentryFlag%d", i );
    ie[i] = GNOME_ICON_ENTRY( gtk_object_get_data ( GTK_OBJECT (w), sz ) );

    fn = gnome_icon_entry_get_filename( ie[i] );
    g_free( si->imageFiles[i] );
    if ( stat( fn, &buf ) == -1 )
    {
      si->imageFiles[i] = NULL;
      continue;
    }
    si->imageFiles[i] = g_strdup( fn );
  }
}

static void CappletPicChanged( GtkWidget *w, GSwitchItConfig* si )
{
  capplet_widget_state_changed(CAPPLET_WIDGET (capplet), TRUE);
}

static void CappletBeepChanged( GtkWidget *w, GSwitchItConfig* si )
{
  capplet_widget_state_changed(CAPPLET_WIDGET (capplet), TRUE);
  si->doBeep = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON( w ) );
}

static void CappletGroupPerWindowChanged( GtkWidget *w, GSwitchItConfig* si )
{
  capplet_widget_state_changed(CAPPLET_WIDGET (capplet), TRUE);
  si->layoutPerApp = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON( w ) );
}

static void CappletSecChanged( GtkWidget *w, GSwitchItConfig* si )
{
  int idx, mask;

  capplet_widget_state_changed(CAPPLET_WIDGET (capplet), TRUE);

  idx = GPOINTER_TO_INT( gtk_object_get_data( GTK_OBJECT( w ), "idx" ) );
  mask = 1 << idx;
  if ( gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON( w ) ) )
    si->secondaries |= mask;
  else
    si->secondaries &= ~mask;

  if ( (si->secondaries + 1) == (1 << XklGetNumGroups()) ) // all secondaries?
    gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON( w ), FALSE );
}

static void CappletSwitchcutChanged( GtkWidget *scmenuItem, GSwitchItConfig * si )
{
  Switchcut * sc;

  capplet_widget_state_changed( CAPPLET_WIDGET (capplet), TRUE );

  sc = gtk_object_get_data( GTK_OBJECT( scmenuItem ), "switchcut" );
  si->switchcutId = sc - switchcuts;

  if( si->switchcutId == total_switchcuts - 1 )
    CappletGrabDialog(scmenuItem, si);
  else
  {
    si->switchcutKeysym = 0;
    CappletUpdateGrabMenu( si );
  }
}

static void CappletTry( GtkWidget *w, GSwitchItConfig* si )
{
  CappletConfigUpdate( w, si );

  GSwitchItConfigSave( si );
}

static void CappletRevert( GtkWidget *w, GSwitchItConfig* si )
{
  GnomeIconEntry* ie;
  GtkCheckButton* sec;
  GtkCheckButton* beep;
  gint i;

  GSwitchItConfigSave( savedState );
  GSwitchItConfigLoad( si );

  for ( i=XklGetNumGroups();
        --i>=0; )
  {
    char sz[30];
    g_snprintf( sz, sizeof(sz), "iconentryFlag%d", i );
    ie = GNOME_ICON_ENTRY( gtk_object_get_data ( GTK_OBJECT (w), sz ) );

    gnome_icon_entry_set_icon( ie,
                               si->imageFiles[i] );

    g_snprintf( sz, sizeof(sz), "secondary%d", i );
    sec = GTK_CHECK_BUTTON( gtk_object_get_data ( GTK_OBJECT (w), sz ) );
    gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON( sec ), (si->secondaries & (1 << i)) != 0 );
  }

  beep = GTK_CHECK_BUTTON( gtk_object_get_data ( GTK_OBJECT (w), "dobeep" ) );
  gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON( beep ), si->doBeep );
}

static void CappletOk( GtkWidget *w, GSwitchItConfig* si )
{
  CappletConfigUpdate( w, si );

  GSwitchItConfigSave( si );
}

static void CappletCancel( GtkWidget *w, GSwitchItConfig* si )
{
  GSwitchItConfigSave( savedState );
}

static void CappletHelp( GtkWidget *w, GSwitchItConfig* si )
{
}

static void CappletSetup( GSwitchItConfig* si )
{
  GtkWidget *hbox;
  GtkWidget *vbox,*vbox1,*vbox2;
  GtkWidget *secondary;
  GtkWidget *frameFlag;
  GtkWidget *iconentryFlag;
  GtkWidget *dobeep;
  GtkWidget *layoutPerApp;
  GtkWidget *switchcutsMenu;
  GtkWidget *scmenuItem;
  GtkWidget *switchcutsLabel;
  Switchcut * sc;

  int i;

  gtk_object_set_data (GTK_OBJECT (capplet), "capplet", capplet);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox);
  gtk_widget_show (vbox);

  gtk_object_set_data_full (GTK_OBJECT (capplet), "vbox", vbox,
                            (GtkDestroyNotify) gtk_widget_unref);

  dobeep = gtk_check_button_new_with_label ( _("Enable beep") );
  gtk_widget_ref (dobeep);
  gtk_object_set_data_full (GTK_OBJECT (capplet),
                            "dobeep",
                            dobeep,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox), dobeep , FALSE, FALSE, 0);
  gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON( dobeep ), si->doBeep );

  gtk_signal_connect( GTK_OBJECT( dobeep ),
                      "toggled",
                      GTK_SIGNAL_FUNC( CappletBeepChanged ),
                      si );

  layoutPerApp = gtk_check_button_new_with_label ( _("Separate layout for each window") );
  gtk_widget_ref ( layoutPerApp );
  gtk_object_set_data_full (GTK_OBJECT (capplet),
                            "layoutPerApp",
                            layoutPerApp,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox), layoutPerApp, FALSE, FALSE, 0);
  gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON( layoutPerApp ), si->layoutPerApp );

  gtk_signal_connect( GTK_OBJECT( layoutPerApp ),
                      "toggled",
                      GTK_SIGNAL_FUNC( CappletGroupPerWindowChanged ),
                      si );

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox);
  gtk_object_set_data_full (GTK_OBJECT (capplet), "hboxflags", hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox), hbox , FALSE, FALSE, 0);

  for ( i=0; i<XklGetNumGroups(); i++ )
  {
    gchar sz[30];
    frameFlag = gtk_frame_new ( XklGetGroupNames()[i] );

    gtk_widget_ref (frameFlag);
    g_snprintf( sz, sizeof(sz), "frameFlag%d", i );
    gtk_object_set_data_full ( GTK_OBJECT (capplet),
                               sz,
                               frameFlag,
                               (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (frameFlag);

    vbox1 = gtk_vbox_new (FALSE, 0);

    gtk_box_pack_start (GTK_BOX (vbox1), gtk_label_new(""), TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), frameFlag, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), gtk_label_new(""), TRUE, TRUE, 0);

    gtk_box_pack_start (GTK_BOX (hbox), vbox1, TRUE, TRUE, 0);

    gtk_frame_set_shadow_type (GTK_FRAME (frameFlag), GTK_SHADOW_ETCHED_OUT);

    iconentryFlag = gnome_icon_entry_new (NULL, NULL);
    gtk_widget_ref (iconentryFlag);
    g_snprintf( sz, sizeof(sz), "iconentryFlag%d", i );
    gtk_object_set_data_full (GTK_OBJECT (capplet),
                              sz,
                              iconentryFlag,
                              (GtkDestroyNotify) gtk_widget_unref);
    gnome_icon_entry_set_icon( GNOME_ICON_ENTRY( iconentryFlag ),
                               si->imageFiles[i] );

    gtk_widget_show (iconentryFlag);

    vbox2 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox2);
    g_snprintf( sz, sizeof(sz), "vbox2%d", i );
    gtk_object_set_data_full (GTK_OBJECT (capplet),
                              sz,
                              vbox2,
                              (GtkDestroyNotify) gtk_widget_unref);

    secondary = gtk_check_button_new_with_label ( _("Secondary") );

    gtk_widget_ref (secondary);
    g_snprintf( sz, sizeof(sz), "secondary%d", i );
    gtk_object_set_data_full (GTK_OBJECT (capplet),
                              sz,
                              secondary,
                              (GtkDestroyNotify) gtk_widget_unref);

    gtk_object_set_data ( GTK_OBJECT (secondary),
                          "idx",
                          GINT_TO_POINTER( i ) );

    gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON( secondary ), (si->secondaries & (1 << i)) != 0 );

    gtk_box_pack_start (GTK_BOX (vbox2), secondary, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox2), iconentryFlag, FALSE, FALSE, 0);

    gtk_container_add (GTK_CONTAINER (frameFlag), vbox2);
    gtk_signal_connect( GTK_OBJECT( gnome_icon_entry_gtk_entry ( GNOME_ICON_ENTRY( iconentryFlag ) ) ),
                        "changed",
                        GTK_SIGNAL_FUNC( CappletPicChanged ),
                        si );
    gtk_signal_connect( GTK_OBJECT( secondary ),
                        "toggled",
                        GTK_SIGNAL_FUNC( CappletSecChanged ),
                        si );
  }

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox);
  gtk_object_set_data_full (GTK_OBJECT (capplet), "hboxsc", hbox,
                            (GtkDestroyNotify) gtk_widget_unref);

  switchcutsLabel = gtk_label_new( _( "Switch shortcut" ) );
  gtk_box_pack_start (GTK_BOX (hbox), switchcutsLabel, FALSE, FALSE, 0);

  switchcutsMenu = gtk_menu_new ();
  gtk_widget_ref( switchcutsMenu );

  gtk_object_set_data_full( GTK_OBJECT (capplet), "switchcutsMenu", switchcutsMenu,
                            (GtkDestroyNotify) gtk_widget_unref );

  scmenuItem = NULL;
  sc = switchcuts;
  for ( i=total_switchcuts;--i>=0; sc++ )
  {
    scmenuItem = gtk_menu_item_new_with_label( _(sc->name) );

    gtk_object_set_data ( GTK_OBJECT (scmenuItem),
                          "switchcut",
                          sc );

    gtk_signal_connect ( GTK_OBJECT (scmenuItem), "activate",
                         GTK_SIGNAL_FUNC( CappletSwitchcutChanged ), si );

    gtk_menu_append( GTK_MENU( switchcutsMenu ), scmenuItem );
    gtk_widget_show( scmenuItem );
  }
  udMenu = GTK_BIN (scmenuItem)->child;
  CappletUpdateGrabMenu(si);

  switchcutsOMenu = gtk_option_menu_new();
  gtk_option_menu_set_menu( GTK_OPTION_MENU( switchcutsOMenu ), switchcutsMenu );
  // initial value
  gtk_option_menu_set_history( GTK_OPTION_MENU( switchcutsOMenu ), si->switchcutId );

  gtk_box_pack_start (GTK_BOX (hbox), switchcutsOMenu, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX (vbox), hbox , FALSE, FALSE, 0);

  gtk_container_add (GTK_CONTAINER (capplet), vbox);

  gtk_signal_connect ( GTK_OBJECT (capplet), "help",
                       GTK_SIGNAL_FUNC (CappletHelp), si );
  gtk_signal_connect ( GTK_OBJECT (capplet), "try",
                       GTK_SIGNAL_FUNC (CappletTry), si );
  gtk_signal_connect ( GTK_OBJECT (capplet), "revert",
                       GTK_SIGNAL_FUNC (CappletRevert), si );
  gtk_signal_connect ( GTK_OBJECT (capplet), "ok",
                       GTK_SIGNAL_FUNC (CappletOk), si );
  gtk_signal_connect ( GTK_OBJECT (capplet), "cancel",
                       GTK_SIGNAL_FUNC (CappletCancel), si );

  gtk_widget_show_all (capplet);
}

int main (int argc, char **argv)
{
  GSwitchItConfig si;
  GSwitchItConfig ssi;
  GError * gconf_error = NULL;
  int init_results;

  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);

  memset( &si, 0, sizeof (si) );
  memset( &ssi, 0, sizeof (ssi) );

  savedState = &ssi;

  init_results = gnome_capplet_init( "gswitchit-properties",
                                     VERSION, argc, argv, NULL, 0, NULL);

  if (init_results < 0)
  {
    g_warning ( "an initialization error occurred while "
                          "starting 'gswitchit-properties-capplet'.\n"
                           "aborting...\n" );
    exit (1);
  }


  if (!gconf_init(argc, argv, &gconf_error))
  {
     g_warning( _("Failed to init GConf: %s\n"), gconf_error->message );
     g_error_free( gconf_error );
     return 1;
  }
  gconf_error = NULL;

  /*client = gnome_master_client ();
  flags = gnome_client_get_flags( client );
  */
  if (init_results != 1)
  {
    XklInit( GDK_DISPLAY());

    GSwitchItConfigInit( &si, TRUE );
    GSwitchItConfigInit( &ssi, TRUE );

    capplet = capplet_widget_new();

    CappletSetup ( &si );
    capplet_gtk_main ();

    GSwitchItConfigTerm( &ssi, FALSE );
    GSwitchItConfigTerm( &si, TRUE );
  }

  return 0;
}

