/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.StandardURIResolver;
import com.icl.saxon.StylesheetStripper;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.LiteralResultElement;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.TreeBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    String href;
    DocumentImpl includedDoc;

    public abstract boolean isImport();

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.HREF) {
                this.href = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkEmpty();
        this.checkTopLevel();
    }

    public XSLStyleSheet getIncludedStyleSheet(XSLStyleSheet xSLStyleSheet, int n) throws TransformerConfigurationException {
        if (this.href == null) {
            return null;
        }
        this.checkEmpty();
        this.checkTopLevel();
        try {
            XSLStyleSheet xSLStyleSheet2 = (XSLStyleSheet)this.getParentNode();
            DocumentInfo documentInfo = this.getDocumentRoot();
            TransformerFactoryImpl transformerFactoryImpl = this.getPreparedStyleSheet().getTransformerFactory();
            Source source = transformerFactoryImpl.getURIResolver().resolve(this.href, this.getBaseURI());
            if (source == null) {
                new StandardURIResolver(transformerFactoryImpl).resolve(this.href, this.getBaseURI());
            }
            if (source instanceof NodeInfo) {
                if (source instanceof Node) {
                    source = new DOMSource((Node)((Object)source));
                } else {
                    throw new TransformerException("URIResolver must not return a " + source.getClass());
                }
            }
            SAXSource sAXSource = transformerFactoryImpl.getSAXSource(source, true);
            XSLStyleSheet xSLStyleSheet3 = xSLStyleSheet2;
            while (xSLStyleSheet3 != null) {
                if (sAXSource.getSystemId().equals(xSLStyleSheet3.getSystemId())) {
                    this.compileError("A stylesheet cannot " + this.getLocalName() + " itself");
                    return null;
                }
                xSLStyleSheet3 = xSLStyleSheet3.getImporter();
            }
            NamePool namePool = this.getDocumentRoot().getNamePool();
            StylesheetStripper stylesheetStripper = new StylesheetStripper();
            stylesheetStripper.setStylesheetRules(namePool);
            TreeBuilder treeBuilder = new TreeBuilder();
            treeBuilder.setNamePool(namePool);
            treeBuilder.setStripper(stylesheetStripper);
            treeBuilder.setNodeFactory(new StyleNodeFactory(namePool));
            treeBuilder.setDiscardCommentsAndPIs(true);
            treeBuilder.setLineNumbering(true);
            this.includedDoc = (DocumentImpl)treeBuilder.build(sAXSource);
            ElementImpl elementImpl = (ElementImpl)this.includedDoc.getDocumentElement();
            if (elementImpl instanceof LiteralResultElement) {
                ((LiteralResultElement)elementImpl).makeStyleSheet(this.getPreparedStyleSheet());
                elementImpl = (ElementImpl)this.includedDoc.getDocumentElement();
            }
            if (!(elementImpl instanceof XSLStyleSheet)) {
                this.compileError("Included document " + this.href + " is not a stylesheet");
                return null;
            }
            XSLStyleSheet xSLStyleSheet4 = (XSLStyleSheet)elementImpl;
            xSLStyleSheet4.setPrecedence(n);
            xSLStyleSheet4.setImporter(xSLStyleSheet);
            xSLStyleSheet4.spliceIncludes();
            return xSLStyleSheet4;
        }
        catch (TransformerException transformerException) {
            this.compileError(transformerException);
            return null;
        }
    }

    public void process(Context context) {
    }
}

