# This is the msttcorefonts spec file as distributed from
# http://corefonts.sourceforge.net/. Use it and enjoy!
# corefonts@resare.com

# some non-redhat users will need to change this. This is the info I've
# gotten so far:
# 
# mandrake 8.2 users should install the 'freetype-tools' package and change
# the define below to '/usr/sbin/ttmkfdir'
# 
# in redhat 8.0 the ttmkfdir util is is in the 'XFree86-font-utils' package
#
# If you needed to change this define in any other way, please email the
# following info to corefonts@resare.com so that I can make future versions
# better:
# 1) Your distribution name and version.
# 2) The correct path to ttmkfdir on your system
# 3) The name of the package that holds ttmkfdir. You can check this by
#    running 'rpm -qf PATH_FROM_QUESTION_2'
%define ttmkfdir /usr/bin/ttmkfdir

# Set this define to "yes" if you have a windows license. This will install
# the Tahoma font also (that is distributed under the ie license, which
# requires a valid windows license)
%define has_windows_license "yes"

%define fontdir /usr/share/fonts/%{name}

# please select the server that is closest to you by replacing the first
# '#' with a '%' one of the following lines.

#define distserver http://belnet.dl.sourceforge.net/sourceforge/corefonts
#define distserver http://flow.dl.sourceforge.net/sourceforge/corefonts
%define distserver http://easynews.dl.sourceforge.net/sourceforge/corefonts
#define distserver http://unc.dl.sourceforge.net/sourceforge/corefonts
#define distserver http://umn.dl.sourceforge.net/sourceforge/corefonts
#define distserver http://twtelecom.dl.sourceforge.net/sourceforge/corefonts
#define distserver http://aleron.dl.sourceforge.net/sourceforge/corefonts
#define distserver http://cesnet.dl.sourceforge.net/sourceforge/corefonts
#define distserver http://switch.dl.sourceforge.net/sourceforge/corefonts

%define name msttcorefonts

Summary: TrueType core fonts for the web
Name: %{name}
Version: 1.3
Release: 4
License: Spec file is GPL, binary rpm is gratis but non-distributable
Group: User Interface/X
BuildArch: noarch
BuildRoot: /var/tmp/%{name}-root
BuildPrereq: %{ttmkfdir}
BuildPrereq: wget
BuildPrereq: cabextract
Prereq: /usr/sbin/chkfontpath
Packager: Daniel Resare <corefonts@resare.com>

%description
The TrueType core fonts for the web that was once available from
http://www.microsoft.com/typography/fontpack/. The src rpm is cleverly
constructed so that the actual fonts are downloaded from Sourceforge's site
at build time. Therefore this package technically does not 'redistribute'
the fonts, it just makes it easy to install them on a linux system.

%prep
rm -rf %{name}
mkdir %{name}
cd %{name}
for i in andale32.exe webdin32.exe trebuc32.exe georgi32.exe verdan32.exe comic32.exe arialb32.exe impact32.exe arial32.exe times32.exe courie32.exe
do
#	wget %{distserver}/$i
true
done
if test "yes" = %{has_windows_license}
then
	wget http://download.microsoft.com/download/ie6sp1/finrel/6_sp1/W98NT42KMeXP/EN-US/IELPKTH.CAB
fi




%build

cd %{name}


mkdir -p %{name}/cab-contents

for i in *.exe *.CAB
do
	if test -f $i
	then
		cabextract --lowercase --directory=cab-contents $i
	fi
done

mkdir fonts
cd fonts

cp ../cab-contents/*.ttf .

%{ttmkfdir} > fonts.dir

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
cd %{name}/fonts
mkdir -p $RPM_BUILD_ROOT/%{fontdir}
cp *.ttf fonts.dir $RPM_BUILD_ROOT/%{fontdir}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
if test $1 -eq 1
then
	/usr/sbin/chkfontpath --add %{fontdir}
fi
# something has probably changed, update the font-config cache
if test -x /usr/bin/fc-cache
then
	/usr/bin/fc-cache
fi

%preun
if test $1 -eq 0
then
	/usr/sbin/chkfontpath --remove %{fontdir}
fi

%files
%attr(-,root,root) %{fontdir}
%dir %{fontdir}

%changelog
* Mon Mar 31 2003 Daniel Resare <noa@resare.com> 1.3-4
- updated microsoft link
- updated sourceforge mirrors

* Mon Nov 25 2002 Daniel Resare <noa@resare.com> 1.3-3
- the install dir is now deleted when the package is uninstalled
- executable permission removed from the fonts
- executes fc-cache after install if it is available

* Thu Nov 07 2002 Daniel Resare <noa@resare.com> 1.3-2
- Microsoft released a new service-pack. New url for Tahoma font.

* Thu Oct 24 2002 Daniel Resare <noa@resare.com> 1.3-1
- removed python hack
- removed python hack info from description
- made tahoma inclusion depend on define
- added some info on the ttmkfdir define

* Tue Aug 27 2002 Daniel Resare <noa@resare.com> 1.2-3
- fixed spec error when tahoma is not included 

* Tue Aug 27 2002 Daniel Resare <noa@resare.com> 1.2-2
- removed tahoma due to unclear licensing
- parametrized ttmkfdir path (for mandrake users)
- changed description text to reflect the new microsoft policy

* Thu Aug 15 2002 Daniel Resare <noa@resare.com> 1.2-1
- changed distserver because microsoft no longer provides them

* Tue Apr 09 2002 Daniel Resare <noa@resare.com> 1.1-3
- fixed post/preun script to actually do what they were supposed to do

* Tue Mar 12 2002 Daniel Resare <noa@resare.com> 1.1-2
- removed cabextact from this package
- added tahoma font from ie5.5 update

* Fri Aug 25 2001 Daniel Resare <noa@metamatrix.se>
- initial version
