#!/bin/sh
# File: slack9.sh
# Configure Thai language for Slackware 9.0
# original by Rachot Wanmuang <rachot64@yahoo.com>
# NOTE: All the installation files were from the RPMs. I just repackaged them for Slackware.
# 2003 Apr 25
# $Id: slack9.sh,v 1.1 2003/05/09 14:17:24 poonlap Exp $

if [ ! -f /etc/slackware-version ]; then
	echo "Are you sure you are using Slackware? Please be sure because this script might mess up other distro. If you are sure please hit <ENTER>, if not it <CTRL+C>."
	read
fi
if [ `whoami` != "root" ]; then
        echo "Must be root to install"
        exit -1
fi
if [ -z $TE_DIR ]; then
        export TE_DIR=`pwd`
fi
source $TE_DIR/te.conf


#uninstall not yet tested
#if [ "$1" == "uninstall" ]; then
#	removepkg thaixfonts-1.2.4-4.noarch 
#fi

SLACK_DIR="$TE_DIR/downloads/slackware"

if [ ! -f /usr/bin/rpm2tgz ]; then
	echo "You do not have rpm2tgz program installed.  Please install from Slackware 9.0 cd.  Setup cannot continue."
	exit 1
fi

mkdir -p $SLACK_DIR

cd $TE_DIR/downloads
if [ $thaixfonts == 1 ]; then
        wget -nd $TLE_RPMS_main/thaixfonts-1.2.4-4.noarch.rpm
fi
if [ $thai_ttf == 1 ]; then
        wget -nd $TLE_RPMS_main/thai-ttf-0.3.0-2_4tle.noarch.rpm
        wget -nd $TLE_RPMS_main/thai-ttf-js-0.0.1-1.noarch.rpm
        wget -nd $TLE_RPMS_main/thai-ttf-js_write-0.0.1-1.noarch.rpm
fi
# applications
if [ $xiterm == 1 ]; then
    wget -nd $TLE_RPMS_main/xiterm+thai-1.05-5.i386.rpm
fi


cd $SLACK_DIR

#using this way may cause uninstallation problems, because packages are not made from makepkg
#later on I will implement that along with package descriptions
echo -e "\033[01;31mNow repackaging RPM to Slackware TGZ.\033[00m" 
rpm2tgz $SLACK_DIR/../*.rpm

if [ ! "$?" == "0" ]; then
	echo "Error!  This may be caused by you lacking rpm-4.0.2-i386-6 package.  Please make sure that rpm-4.0.2-i386-6 is installed on your Slackware machine (should be on the cd)"
	exit 1
fi

#editing Xkb
echo -ne "\nChanging X Keyboard Layout to be \033[01;32mus,th\033[00m...\n"
echo -ne "\033[01;32mALT+SHIFT\033[00m will be the toggle sequence\n"
cp /etc/X11/XF86Config /etc/X11/XF86Config.backup
grep '^[^#].*XkbLayout' /etc/X11/XF86Config 1> /dev/null 2> /dev/null
if [ $? == "1" ] ; then
	echo -ne "\033[01;31mError:\033[00m XkbLayout identifier not found in /etc/X11/XF86Config\n"
	echo "       Please add the following lines yourself under your keyboard section in the X config file later:"
	echo "	 	Option \"XkbLayout\" \"us,th\""
	echo "	 	Option \"XkbOptions\" \"grp:alt_shift_toggle\""
else
	cat /etc/X11/XF86Config.backup | sed 's/^[^#].*"XkbLayout".*$/        Option  "XkbLayout" "us,th"\
        Option  "XkbOptions" "grp:alt_shift_toggle"/' > /etc/X11/XF86Config
	echo -ne "Just in case.. I have backed up your original X config file to \033[01;34m/etc/X11/XF86Config.backup\033[00m\n"
fi
echo -e "\nPress <ENTER> to continue\n"
read
source $TE_DIR/te.conf

#install X fonts, make fonts.dir, add FontPath to XF86Config
if [ $thaixfonts == 1 ]; then
	installpkg -menu -ask $SLACK_DIR/thaixfonts-1.2.4-4.noarch.tgz
	if [ "$?" == "99" ]; then
		cd .. && rm -rf slackware
		exit 99
	fi
	if [ -f /usr/X11R6/bin/mkfontdir ]; then
		/usr/X11R6/bin/mkfontdir /usr/X11R6/lib/X11/fonts/local
	else
		echo -ne "\033[01;31mError: Cannot create fonts.dir lack of mkfontdir command. Please install and rerun script.\n"
		cd .. && rm -rf slackware
		exit 1
	fi
	#eww...!  messy code... it works... any better ideas?
	grep "/usr/X11R6/lib/X11/fonts/local" /etc/X11/XF86Config 1> /dev/null 2> /dev/null
	if [ "$(echo $?)" == "1" ] ; then
		head -n $(grep -n FontPath /etc/X11/XF86Config | tail -n 1 | cut -f 1 -d :) \
			/etc/X11/XF86Config > /etc/X11/XF86Config.tmp
		echo '	FontPath     "/usr/X11R6/lib/X11/fonts/local"' >> /etc/X11/XF86Config.tmp
		tail -n $(expr $(wc -l /etc/X11/XF86Config | cut -f 1 -d /) - \
			$(grep -n FontPath /etc/X11/XF86Config | tail -n 1 | cut -f 1 -d :)) \
			/etc/X11/XF86Config >> /etc/X11/XF86Config.tmp
		mv /etc/X11/XF86Config.tmp /etc/X11/XF86Config
	fi
fi

#install true type fonts
if [ $thai_ttf == 1 ]; then
	installpkg -menu -ask $SLACK_DIR/thai-ttf*
fi

#install xiterm
if [ $xiterm == 1 ]; then
	installpkg -menu -ask $SLACK_DIR/xiterm+thai-1.05-5.i386.tgz
fi


cd .. && rm -rf slackware
