// declarations of portable directory/file utility functions -*- C++ -*-
/* fileutil.h
 *
 * Copyright (C) 2001 Theppitak Karoonboonyanan,
 *   National Electronics and Computer Technology Center
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.  
 */

//
// fileutil.h - declarations of portable directory/file utility functions
// Created: 11 Jul 1996
// Author:  Theppitak Karoonboonyanan
//

#ifndef _PENKNIFEPP_FILEUTIL_H
#define _PENKNIFEPP_FILEUTIL_H

#include <string>

namespace PenKnife {

    extern "C" {
#if defined(_WIN32) || defined(DOS)
        const char DIR_DELIM = '\\';
#  define DIR_DELIM_STR  "\\"
#elif defined(unix) || (defined(__APPLE__) && defined(__GNUC__))
        const char DIR_DELIM = '/';
#  define DIR_DELIM_STR  "/"
#endif

        std::string FullPath(const char* dir, const char* file, const char* ext);
        int CopyFile(const char* from, const char* to);
        int MoveFile(const char* from, const char* to);

        // make dir if not exists
        bool PrepareDir(const char* dir);
    }

} // namespace PenKnife

#endif  // _PENKNIFEPP_FILEUTIL_H

