// Hexadecimal Stream Manipulators -*- C++ -*-
/*
 * hexmanip.h 
 *
 * Copyright (C) 2001 Theppitak Karoonboonyanan,
 *   National Electronics and Computer Technology Center
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.  
 */

//
// hexmanip.h - hexadecimal stream manipulators
// Created: 13 Aug 1999
// Author:  Theppitak Karoonboonyanan
//

#ifndef _PENKNIFEPP_HEXMANIP_H
#define _PENKNIFEPP_HEXMANIP_H

#include <iomanip>

namespace PenKnife {

    template <class T>
    class omanip {
    public:
        omanip(std::ostream& (*f)(std::ostream&, T), T t)
            : f_(f), t_(t) {}
        friend std::ostream& operator<<(std::ostream& os, omanip& m)
            { return m.f_(m.t_); }
    private:
        T t_;
        std::ostream& (*f_)(std::ostream&, T);
    };


    //
    // HexByte(unsigned char b)
    // : ostream manipulator
    //
    inline std::ostream& HexByte_(std::ostream& os, unsigned char c)
    {
        return os << std::hex << std::setw(2) << std::setfill('0')
                  << (unsigned int)c << std::setfill(' ') << std::dec;
    }

#ifdef IOMANIPdeclare
    typedef unsigned char uchar;
    IOMANIPdeclare(uchar)
        inline OMANIP(uchar) HexByte(unsigned char c)
    {
        return OMANIP(uchar)(HexByte_, c);
    }

#else // !IOMANIPdeclare
    inline omanip<unsigned char> HexByte(unsigned char c)
    {
        return omanip<unsigned char>(HexByte_, c);
    }         
#endif // IOMANIPdeclare

//
// HexStream(const unsigned char* pData, int nData)
// : ostream manipulator
//
    struct BytesData_ {
        int                  nData;
        const unsigned char* pData;
    public:
        BytesData_(int nData, const unsigned char* pData)
            : nData(nData), pData(pData) {}
    };

    std::ostream& HexStream_(std::ostream& os, BytesData_ bd);

#ifdef IOMANIPdeclare
    IOMANIPdeclare(BytesData_)
    inline OMANIP(BytesData_) HexStream(int nData, const unsigned char* pData)
    {
        return OMANIP(BytesData_)(HexStream_, BytesData_(nData, pData));
    }
#else // !IOMANIPdeclare
/*
  inline std::omanip<BytesData_> HexStream(int nData, const unsigned char* pData)
  {
  return std::omanip<BytesData_>(HexStream_, BytesData_(nData, pData));
  }*/

    inline omanip<BytesData_> HexStream(int nData, const unsigned char* pData)
    {
        return omanip<BytesData_>(HexStream_, BytesData_(nData, pData));
    }       
#endif // IOMANIPdeclare

} // namespace PenKnife

#endif  // _PENKNIFEPP_HEXMANIP_H
