// general macros -*- C++ -*-
/* macros.h
 *
 * Copyright (C) 2001 Theppitak Karoonboonyanan,
 *   National Electronics and Computer Technology Center
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.  
 */

//
// macros.h - general macros
// Created : 25 Apr 2003
// Author  : Theppitak Karoonboonyanan
//

#ifndef _PENKNIFEPP_MACROS_H
#define _PENKNIFEPP_MACROS_H

//
// Namespace Boundary
//

#ifdef PENKNIFEPP_WITHOUT_NAMESPACE
# define BEGIN_NAMESPACE(ns)
# define END_NAMESPACE
#else
# define BEGIN_NAMESPACE(ns) namespace ns {
# define END_NAMESPACE       }
#endif //  PENKNIFEPP_WITHOUT_NAMESPACE

//
// Debugging Aid
//

# ifndef ASSERT
#   include <assert.h>
#   define ASSERT(e)  assert(e)
# endif // ASSERT

# ifndef VERIFY
#   ifdef NDEBUG
#     define VERIFY(e)  ((void)(e))
#   else
#     define VERIFY(e)  ASSERT(e)
#   endif // NDEBUG
# endif // VERIFY

#endif  // _PENKNIFEPP_MACROS_H

